# -*- coding: mbcs -*-
# Created by makepy.py version 0.4.95
# By python version 2.5.2 (r252:60911, Feb 21 2008, 13:11:45) [MSC v.1310 32 bit (Intel)]
# From type library 'Spice.tlb'
# On Wed Oct 14 11:05:34 2009
"""Spice Type Library"""
makepy_version = '0.4.95'
python_version = 0x20502f0

import win32com.client.CLSIDToClass, pythoncom
import win32com.client.util
from pywintypes import IID
from win32com.client import Dispatch

# The following 3 lines may need tweaking for the particular server
# Candidates are pythoncom.Missing, .Empty and .ArgNotFound
defaultNamedOptArg=pythoncom.Empty
defaultNamedNotOptArg=pythoncom.Empty
defaultUnnamedArg=pythoncom.Empty

CLSID = IID('{B11EB269-E9B4-45D4-A193-0F8E6E30032C}')
MajorVersion = 5
MinorVersion = 5
LibraryFlags = 8
LCID = 0x409

class constants:
	eDevSysKind                   =0x1        # from enum AppKindEnum
	eEmbeddedKind                 =0x4        # from enum AppKindEnum
	eEvaluationKind               =0x5        # from enum AppKindEnum
	eInvalidAppKind               =0x0        # from enum AppKindEnum
	eRunTimeSysKind               =0x2        # from enum AppKindEnum
	eStudEdKind                   =0x3        # from enum AppKindEnum
	eAlphaCPU                     =0x7        # from enum AppTargCPUEnum
	eArmCPU                       =0x8        # from enum AppTargCPUEnum
	eIntelx86CPU                  =0x3        # from enum AppTargCPUEnum
	eInvalidTargCPU               =0x0        # from enum AppTargCPUEnum
	eMIPSCPU                      =0x6        # from enum AppTargCPUEnum
	eMotorola68kCPU               =0x1        # from enum AppTargCPUEnum
	ePARISCCPU                    =0x5        # from enum AppTargCPUEnum
	ePowerPCCPU                   =0x2        # from enum AppTargCPUEnum
	eSPARCCPU                     =0x4        # from enum AppTargCPUEnum
	eX64CPU                       =0x9        # from enum AppTargCPUEnum
	eAIXOS                        =0xc        # from enum AppTargOSEnum
	eBeOS                         =0xb        # from enum AppTargOSEnum
	eCarbonOS                     =0x10       # from enum AppTargOSEnum
	eHPUXOS                       =0x6        # from enum AppTargOSEnum
	eInvalidTargOS                =0x0        # from enum AppTargOSEnum
	eIrixOS                       =0x9        # from enum AppTargOSEnum
	eLinux64OS                    =0x13       # from enum AppTargOSEnum
	eLinuxOS                      =0x8        # from enum AppTargOSEnum
	eMacOS                        =0x1        # from enum AppTargOSEnum
	eOSF1OS                       =0xd        # from enum AppTargOSEnum
	ePharlapOS                    =0xf        # from enum AppTargOSEnum
	ePowerMaxOS                   =0x7        # from enum AppTargOSEnum
	eRTXOS                        =0x11       # from enum AppTargOSEnum
	eRhapsodyOS                   =0xa        # from enum AppTargOSEnum
	eSolaris1OS                   =0x4        # from enum AppTargOSEnum
	eSolaris2OS                   =0x5        # from enum AppTargOSEnum
	eVxWorksOS                    =0xe        # from enum AppTargOSEnum
	eWin31OS                      =0x2        # from enum AppTargOSEnum
	eWin64OS                      =0x12       # from enum AppTargOSEnum
	eWin95NTOS                    =0x3        # from enum AppTargOSEnum
	eBad                          =0x0        # from enum ExecStateEnum
	eIdle                         =0x1        # from enum ExecStateEnum
	eRunTopLevel                  =0x2        # from enum ExecStateEnum
	eRunning                      =0x3        # from enum ExecStateEnum
	eDefaultFPBehavior            =0x1        # from enum FPBehaviorEnum
	eFloating                     =0x2        # from enum FPBehaviorEnum
	eFloatingAutoHide             =0x3        # from enum FPBehaviorEnum
	eInvalidFPBehavior            =0x0        # from enum FPBehaviorEnum
	eModal                        =0x4        # from enum FPBehaviorEnum
	eRTPCentered                  =0x1        # from enum FPRunTimePosEnum
	eRTPCustom                    =0x4        # from enum FPRunTimePosEnum
	eRTPMaximized                 =0x2        # from enum FPRunTimePosEnum
	eRTPMinimized                 =0x3        # from enum FPRunTimePosEnum
	eRTPUnchanged                 =0x0        # from enum FPRunTimePosEnum
	eClosed                       =0x2        # from enum FPStateEnum
	eHidden                       =0x3        # from enum FPStateEnum
	eInvalidFPState               =0x0        # from enum FPStateEnum
	eMaximized                    =0x5        # from enum FPStateEnum
	eMinimized                    =0x4        # from enum FPStateEnum
	eVisible                      =0x1        # from enum FPStateEnum
	eGIF                          =0x2        # from enum HTMLImageFormatEnum
	eJPEG                         =0x1        # from enum HTMLImageFormatEnum
	ePNG                          =0x0        # from enum HTMLImageFormatEnum
	eImgDataFmtEMF                =0x2        # from enum ImgDataToFmtEnum
	eImgDataFmtJPEG               =0x1        # from enum ImgDataToFmtEnum
	eImgDataFmtPNG                =0x0        # from enum ImgDataToFmtEnum
	eLibScopeInvalid              =0x0        # from enum LibraryItemScopeEnum
	eLibScopePrivate              =0x2        # from enum LibraryItemScopeEnum
	eLibScopePublic               =0x1        # from enum LibraryItemScopeEnum
	eProtected                    =0x3        # from enum LibraryItemScopeEnum
	eLandscape                    =0x1        # from enum PageOrientationEnum
	ePortrait                     =0x0        # from enum PageOrientationEnum
	eRotatedLandscape             =0x3        # from enum PageOrientationEnum
	eRotatedPortrait              =0x2        # from enum PageOrientationEnum
	eComplete                     =0x4        # from enum PrintFormatEnum
	eCustom                       =0x0        # from enum PrintFormatEnum
	eStandard                     =0x1        # from enum PrintFormatEnum
	eUsingPanel                   =0x2        # from enum PrintFormatEnum
	eUsingSubVI                   =0x3        # from enum PrintFormatEnum
	eBitmapMethod                 =0x2        # from enum PrintMethodsEnum
	ePostscriptMethod             =0x1        # from enum PrintMethodsEnum
	eStandardMethod               =0x0        # from enum PrintMethodsEnum
	eESysDAQ                      =0x4        # from enum VIExecSysEnum
	eESysInstrIO                  =0x3        # from enum VIExecSysEnum
	eESysInvalid                  =0x0        # from enum VIExecSysEnum
	eESysNormal                   =0x2        # from enum VIExecSysEnum
	eESysOther1                   =0x5        # from enum VIExecSysEnum
	eESysOther2                   =0x6        # from enum VIExecSysEnum
	eESysSameAsCaller             =0x7        # from enum VIExecSysEnum
	eESysUserInterface            =0x1        # from enum VIExecSysEnum
	eInvalidLockState             =0x0        # from enum VILockStateEnum
	eLockedNoPwdState             =0x2        # from enum VILockStateEnum
	ePwdProtectedState            =0x3        # from enum VILockStateEnum
	eUnlockedState                =0x1        # from enum VILockStateEnum
	ePriAboveNormal               =0x3        # from enum VIPriorityEnum
	ePriBackground                =0x1        # from enum VIPriorityEnum
	ePriCritical                  =0x5        # from enum VIPriorityEnum
	ePriHigh                      =0x4        # from enum VIPriorityEnum
	ePriInvalid                   =0x0        # from enum VIPriorityEnum
	ePriNormal                    =0x2        # from enum VIPriorityEnum
	ePriSubroutine                =0x6        # from enum VIPriorityEnum
	eConfigurationVIType          =0x5        # from enum VITypeEnum
	eControlVIType                =0x2        # from enum VITypeEnum
	eFacadeVIType                 =0x7        # from enum VITypeEnum
	eGlobalVIType                 =0x3        # from enum VITypeEnum
	eInvalidVIType                =0x0        # from enum VITypeEnum
	eMethodVIType                 =0x8        # from enum VITypeEnum
	ePolymorphicVIType            =0x4        # from enum VITypeEnum
	eStandardVIType               =0x1        # from enum VITypeEnum
	eStatechartVIType             =0x9        # from enum VITypeEnum
	eSubSystemVIType              =0x6        # from enum VITypeEnum

from win32com.client import DispatchBaseClass
class VirtualInstrument(DispatchBaseClass):
	"""VI DispInterface"""
	CLSID = IID('{49859563-694E-4434-8E8F-1FA189F1337A}')
	coclass_clsid = None

	def Abort(self):
		"""Aborts the VI execution."""
		return self._oleobj_.InvokeTypes(1004, LCID, 1, (24, 0), (),)

	def Call(self, paramNames=defaultNamedOptArg, paramVals=defaultNamedOptArg):
		"""Call the VI as a subVI"""
		return self._ApplyTypes_(1015, 1, (24, 0), ((16396, 19), (16396, 19)), 'Call', None,paramNames
			, paramVals)

	def Call2(self, paramNames=defaultNamedOptArg, paramVals=defaultNamedOptArg, openFP=defaultNamedOptArg, CloseFPAfterCall=defaultNamedOptArg
			, SuspendOnCall=defaultNamedOptArg, bringAppToFront=defaultNamedOptArg):
		"""Calls the specified vi as a sub vi. Call2 allows you to optionally open the front panel before call, closes it afterwards or suspend the VI at the start of call. You can also optionally make LabVIEW as the active application whenever the front panel """
		return self._ApplyTypes_(1030, 1, (24, 0), ((16396, 19), (16396, 19), (12, 17), (12, 17), (12, 17), (12, 17)), 'Call2', None,paramNames
			, paramVals, openFP, CloseFPAfterCall, SuspendOnCall, bringAppToFront
			)

	def CenterFrontPanel(self):
		"""Specifies whether to automatically center the front panel window on the computer screen."""
		return self._oleobj_.InvokeTypes(1089, LCID, 1, (24, 0), (),)

	def CloseFrontPanel(self):
		"""Closes the front panel window."""
		return self._oleobj_.InvokeTypes(1061, LCID, 1, (24, 0), (),)

	def FPGetRuntimePos(self, type=pythoncom.Missing, position=pythoncom.Missing, size=pythoncom.Missing, monitor=pythoncom.Missing
			, useCurPos=pythoncom.Missing, useCurSize=pythoncom.Missing):
		"""Returns the position of the run-time window."""
		return self._ApplyTypes_(1093, 1, (24, 0), ((16396, 18), (16396, 18), (16396, 18), (16396, 18), (16396, 18), (16396, 18)), 'FPGetRuntimePos', None,type
			, position, size, monitor, useCurPos, useCurSize
			)

	def FPRunTimePosRunCentered(self, monitor=defaultNamedOptArg, size=defaultNamedOptArg):
		"""Sets a VI to center its front panel every time the VI runs."""
		return self._oleobj_.InvokeTypes(1095, LCID, 1, (24, 0), ((12, 17), (12, 17)),monitor
			, size)

	def FPRunTimePosRunCustom(self, position=defaultNamedOptArg, size=defaultNamedOptArg):
		"""Sets a custom position for the VI to move its front panel to every time the VI runs."""
		return self._oleobj_.InvokeTypes(1098, LCID, 1, (24, 0), ((12, 17), (12, 17)),position
			, size)

	def FPRunTimePosRunMax(self, monitor=defaultNamedOptArg):
		"""Sets a VI to maximize its front panel every time the VI runs."""
		return self._oleobj_.InvokeTypes(1096, LCID, 1, (24, 0), ((12, 17),),monitor
			)

	def FPRunTimePosRunMin(self, monitor=defaultNamedOptArg):
		"""Sets a VI to minimize its front panel every time the VI runs."""
		return self._oleobj_.InvokeTypes(1097, LCID, 1, (24, 0), ((12, 17),),monitor
			)

	def FPRunTimePosRunUnchanged(self):
		"""Sets the VI to not move its front panel when the VI runs."""
		return self._oleobj_.InvokeTypes(1094, LCID, 1, (24, 0), (),)

	def GenerateCCodeVariant(self, configParams=defaultNamedNotOptArg, fileList=pythoncom.Missing):
		"""Contains the code generation attributes (name, value pairs) that determine how the LabVIEW C Code Generator generates the C code from the block diagram. Any attributes you do not set use the default behavior."""
		return self._ApplyTypes_(1088, 1, (24, 0), ((12, 1), (16396, 2)), 'GenerateCCodeVariant', None,configParams
			, fileList)

	def GetControlValue(self, controlName=defaultNamedNotOptArg):
		"""Get the value of the named control. The first time you call this method on a VI whose front panel is not open, this method returns the default values of the control rather than the actual values. Thereafter, it returns the actual value."""
		return self._ApplyTypes_(1013, 1, (12, 0), ((8, 1),), 'GetControlValue', None,controlName
			)

	def GetLockState(self, pwdInCache=pythoncom.Missing):
		"""Returns the lock state of the VI and indicates whether the password for the VI is in the password cache."""
		return self._ApplyTypes_(1021, 1, (12, 0), ((16396, 18),), 'GetLockState', None,pwdInCache
			)

	def GetPanelImage(self, visibleOnly=defaultNamedOptArg, imgDepth=defaultNamedOptArg, img=pythoncom.Missing, colors=pythoncom.Missing
			, bounds=pythoncom.Missing):
		"""LabVIEW no longer supports this method. Use the Get Panel Image method instead."""
		return self._ApplyTypes_(1016, 1, (24, 0), ((12, 17), (12, 17), (16396, 18), (16396, 18), (16396, 18)), 'GetPanelImage', None,visibleOnly
			, imgDepth, img, colors, bounds)

	def ImportVIStrings(self, stringFile=defaultNamedNotOptArg, interactive=defaultNamedOptArg, logFile=defaultNamedOptArg):
		"""Imports the following strings about VI and front panel objects from a tagged text file: VI name and description, object caption labels, object free labels, default data (string, table, path, and array default data), private data (listbox item names, """
		return self._oleobj_.InvokeTypes(1001, LCID, 1, (24, 0), ((8, 1), (12, 17), (12, 17)),stringFile
			, interactive, logFile)

	def OldOpenFrontPanel(self, activate=defaultNamedOptArg, state=defaultNamedOptArg):
		"""Opens the front panel window and returns an error if the front panel is already open. LabVIEW no longer supports this method. Use the Open FP method instead."""
		return self._oleobj_.InvokeTypes(1060, LCID, 1, (24, 0), ((12, 17), (12, 17)),activate
			, state)

	def OpenFrontPanel(self, activate=defaultNamedOptArg, state=defaultNamedOptArg):
		"""Opens the front panel window. If the front panel is already open, this method changes the state of the front panel window to the state you wire to this method."""
		return self._oleobj_.InvokeTypes(1080, LCID, 1, (24, 0), ((12, 17), (12, 17)),activate
			, state)

	def PrintPanel(self, entirePanel=defaultNamedOptArg):
		"""Prints just the front panel to the current printer. You cannot use this method to print a block diagram, list of controls, or polymorphic VI front panel."""
		return self._oleobj_.InvokeTypes(1019, LCID, 1, (24, 0), ((12, 17),),entirePanel
			)

	def PrintVIToPrinter(self, format=defaultNamedOptArg, scalePanel=defaultNamedOptArg, scaleDiagram=defaultNamedOptArg, pageHeaders=defaultNamedOptArg
			, pageBreaks=defaultNamedOptArg, sectionHeaders=defaultNamedOptArg):
		"""Prints the VI information to a printer."""
		return self._oleobj_.InvokeTypes(1005, LCID, 1, (24, 0), ((12, 17), (12, 17), (12, 17), (12, 17), (12, 17), (12, 17)),format
			, scalePanel, scaleDiagram, pageHeaders, pageBreaks, sectionHeaders
			)

	def ReinitializeAllToDefault(self):
		"""Changes the current values of all controls on the front panel to their defaults."""
		return self._oleobj_.InvokeTypes(1012, LCID, 1, (24, 0), (),)

	def Run(self, async=defaultNamedOptArg):
		"""Run the VI as a top level VI."""
		return self._oleobj_.InvokeTypes(1017, LCID, 1, (24, 0), ((12, 17),),async
			)

	def SetControlValue(self, controlName=defaultNamedNotOptArg, value=defaultNamedNotOptArg):
		"""Set the value of the named control."""
		return self._oleobj_.InvokeTypes(1014, LCID, 1, (24, 0), ((8, 1), (12, 1)),controlName
			, value)

	def _GetCtrlArrayElemDefaultValVariant(self, controlNamesPath=defaultNamedNotOptArg):
		"""Gets the default value for the array element specified by the array of strings input. The array of strings input needs to be in the format Cluster1>>Cluster2>>Array1>>Cluster3>>Array2. This default value is returned as variant data. Use the Variant t"""
		return self._ApplyTypes_(1131, 1, (12, 0), ((12, 1),), '_GetCtrlArrayElemDefaultValVariant', None,controlNamesPath
			)

	def _GetCtrlDefaultValVariant(self, controlName=defaultNamedNotOptArg):
		"""Gets the default value of a named control or indicator as variant data. Use the Variant to Data function to convert the data to another LabVIEW data type."""
		return self._ApplyTypes_(1130, 1, (12, 0), ((8, 1),), '_GetCtrlDefaultValVariant', None,controlName
			)

	def _GetTag(self, tagName=defaultNamedNotOptArg, isPersistent=pythoncom.Missing, value=pythoncom.Missing):
		"""Gets the data set by using Set Tag."""
		return self._ApplyTypes_(1038, 1, (11, 0), ((8, 1), (16396, 18), (16396, 18)), '_GetTag', None,tagName
			, isPersistent, value)

	def _GetTagNames(self, TagNames=pythoncom.Missing):
		"""Get a list of all tags associated with a VI. Return TRUE if any tags were found and FALSE if no tags were found."""
		return self._ApplyTypes_(1107, 1, (11, 0), ((16396, 2),), '_GetTagNames', None,TagNames
			)

	def _RemoveAllTags(self):
		"""Removes all tags. Returns number of tags removed."""
		return self._oleobj_.InvokeTypes(1036, LCID, 1, (3, 0), (),)

	def _RemoveTag(self, tagName=defaultNamedNotOptArg, oldValue=pythoncom.Missing):
		"""Removes a tag set by calling Set Tag."""
		return self._ApplyTypes_(1039, 1, (11, 0), ((8, 1), (16396, 18)), '_RemoveTag', None,tagName
			, oldValue)

	def _RemoveTags(self, tagName=defaultNamedNotOptArg):
		"""Removes all tags with the specified tag name.  Returns number of tags removed."""
		return self._oleobj_.InvokeTypes(1033, LCID, 1, (3, 0), ((8, 1),),tagName
			)

	def _SetTag(self, tagName=defaultNamedNotOptArg, value=defaultNamedNotOptArg, isPersistent=defaultNamedOptArg, oldValue=pythoncom.Missing):
		"""Sets a Tag for the VI. Persistence specifies whether the tag will survive a save/load."""
		return self._ApplyTypes_(1037, 1, (11, 0), ((8, 1), (12, 1), (12, 17), (16396, 18)), '_SetTag', None,tagName
			, value, isPersistent, oldValue)

	def _SetTags(self, tagName=defaultNamedNotOptArg, value=defaultNamedNotOptArg):
		"""Replaces the data associated with all tags of specified name. Returns number of tags changed."""
		return self._oleobj_.InvokeTypes(1034, LCID, 1, (3, 0), ((8, 1), (12, 1)),tagName
			, value)

	def _SetTagsPersistence(self, tagName=defaultNamedNotOptArg, isPersistent=defaultNamedNotOptArg):
		"""Changes persistence of all tags of specified name. Returns number of tags changed."""
		return self._oleobj_.InvokeTypes(1035, LCID, 1, (3, 0), ((8, 1), (11, 1)),tagName
			, isPersistent)

	_prop_map_get_ = {
		"AllowDebugging": (518, 2, (11, 0), (), "AllowDebugging", None),
		"BDSize": (543, 2, (3, 0), (), "BDSize", None),
		"Callees": (545, 2, (12, 0), (), "Callees", None),
		"Callers": (544, 2, (12, 0), (), "Callers", None),
		"CloneName": (645, 2, (8, 0), (), "CloneName", None),
		"CloseFPAfterCall": (523, 2, (11, 0), (), "CloseFPAfterCall", None),
		"CodeSize": (540, 2, (3, 0), (), "CodeSize", None),
		"DataSize": (541, 2, (3, 0), (), "DataSize", None),
		"Description": (502, 2, (8, 0), (), "Description", None),
		"EditMode": (558, 2, (11, 0), (), "EditMode", None),
		"ExecPriority": (526, 2, (3, 0), (), "ExecPriority", None),
		"ExecState": (557, 2, (3, 0), (), "ExecState", None),
		"FPAllowRTPopup": (508, 2, (11, 0), (), "FPAllowRTPopup", None),
		"FPAutoCenter": (511, 2, (11, 0), (), "FPAutoCenter", None),
		"FPBehavior": (601, 2, (3, 0), (), "FPBehavior", None),
		"FPHiliteReturnButton": (509, 2, (11, 0), (), "FPHiliteReturnButton", None),
		"FPKeepWinProps": (575, 2, (11, 0), (), "FPKeepWinProps", None),
		"FPMinimizeable": (583, 2, (11, 0), (), "FPMinimizeable", None),
		"FPModificationBitSet": (538, 2, (3, 0), (), "FPModificationBitSet", None),
		"FPMonitor": (629, 2, (2, 0), (), "FPMonitor", None),
		"FPResizable": (507, 2, (11, 0), (), "FPResizable", None),
		"FPResizeable": (584, 2, (11, 0), (), "FPResizeable", None),
		"FPRunTransparently": (628, 2, (11, 0), (), "FPRunTransparently", None),
		"FPShowMenuBar": (513, 2, (11, 0), (), "FPShowMenuBar", None),
		"FPShowScrollBars": (512, 2, (11, 0), (), "FPShowScrollBars", None),
		"FPSize": (542, 2, (3, 0), (), "FPSize", None),
		"FPSizeToScreen": (510, 2, (11, 0), (), "FPSizeToScreen", None),
		"FPState": (608, 2, (3, 0), (), "FPState", None),
		"FPTitleBarVisible": (505, 2, (11, 0), (), "FPTitleBarVisible", None),
		"FPTransparency": (627, 2, (16, 0), (), "FPTransparency", None),
		"FPWinBounds": (536, 2, (12, 0), (), "FPWinBounds", None),
		"FPWinClosable": (506, 2, (11, 0), (), "FPWinClosable", None),
		"FPWinCustomTitle": (561, 2, (11, 0), (), "FPWinCustomTitle", None),
		"FPWinIsFrontMost": (535, 2, (11, 0), (), "FPWinIsFrontMost", None),
		"FPWinOpen": (534, 2, (11, 0), (), "FPWinOpen", None),
		"FPWinOrigin": (552, 2, (12, 0), (), "FPWinOrigin", None),
		"FPWinPanelBounds": (556, 2, (12, 0), (), "FPWinPanelBounds", None),
		"FPWinTitle": (553, 2, (8, 0), (), "FPWinTitle", None),
		"HelpDocumentPath": (533, 2, (8, 0), (), "HelpDocumentPath", None),
		"HelpDocumentTag": (532, 2, (8, 0), (), "HelpDocumentTag", None),
		"IsCloneVI": (646, 2, (11, 0), (), "IsCloneVI", None),
		"IsReentrant": (525, 2, (11, 0), (), "IsReentrant", None),
		"LogAtFinish": (550, 2, (11, 0), (), "LogAtFinish", None),
		"LogFilePath": (549, 2, (8, 0), (), "LogFilePath", None),
		"Name": (500, 2, (8, 0), (), "Name", None),
		# Method 'OwningApp' returns object of type '_Application'
		"OwningApp": (623, 2, (9, 0), (), "OwningApp", '{F7E928FD-D76E-4B3D-B7B7-3E97A9609460}'),
		"Path": (501, 2, (8, 0), (), "Path", None),
		"PreferredExecSystem": (559, 2, (3, 0), (), "PreferredExecSystem", None),
		"PrintHeaderDatePrint": (592, 2, (11, 0), (), "PrintHeaderDatePrint", None),
		"PrintHeaderModifyDate": (593, 2, (11, 0), (), "PrintHeaderModifyDate", None),
		"PrintHeaderPageNumber": (594, 2, (11, 0), (), "PrintHeaderPageNumber", None),
		"PrintHeaderVIIcon": (595, 2, (11, 0), (), "PrintHeaderVIIcon", None),
		"PrintHeaderVIName": (590, 2, (11, 0), (), "PrintHeaderVIName", None),
		"PrintLogFileAtFinish": (551, 2, (11, 0), (), "PrintLogFileAtFinish", None),
		"PrintMargins": (589, 2, (12, 0), (), "PrintMargins", None),
		"PrintingBDScaling": (610, 2, (11, 0), (), "PrintingBDScaling", None),
		"PrintingFPScaling": (588, 2, (11, 0), (), "PrintingFPScaling", None),
		"PrintingHeaderVIPath": (596, 2, (11, 0), (), "PrintingHeaderVIPath", None),
		"PrintingHeaders": (587, 2, (11, 0), (), "PrintingHeaders", None),
		"PrintingOrientation": (586, 2, (3, 0), (), "PrintingOrientation", None),
		"ReentrancyType": (648, 2, (12, 0), (), "ReentrancyType", None),
		"RunOnOpen": (524, 2, (11, 0), (), "RunOnOpen", None),
		"RunTimeMenuPath": (580, 2, (8, 0), (), "RunTimeMenuPath", None),
		"ShowFPOnCall": (522, 2, (11, 0), (), "ShowFPOnCall", None),
		"ShowFPOnLoad": (521, 2, (11, 0), (), "ShowFPOnLoad", None),
		"SuspendOnCall": (555, 2, (11, 0), (), "SuspendOnCall", None),
		"TBShowAbortButton": (517, 2, (11, 0), (), "TBShowAbortButton", None),
		"TBShowFreeRunButton": (516, 2, (11, 0), (), "TBShowFreeRunButton", None),
		"TBShowRunButton": (515, 2, (11, 0), (), "TBShowRunButton", None),
		"TBVisible": (514, 2, (11, 0), (), "TBVisible", None),
		"VIModificationBitSet": (537, 2, (3, 0), (), "VIModificationBitSet", None),
		"VIType": (562, 2, (3, 0), (), "VIType", None),
		"_CPTM_CRC": (614, 2, (3, 0), (), "_CPTM_CRC", None),
		"_CPTM_CRC_New": (639, 2, (3, 0), (), "_CPTM_CRC_New", None),
		"_CalleesPaths": (640, 2, (12, 0), (), "_CalleesPaths", None),
		"_CallersPaths": (641, 2, (12, 0), (), "_CallersPaths", None),
		"_FPWinOSWindow": (615, 2, (3, 0), (), "_FPWinOSWindow", None),
	}
	_prop_map_put_ = {
		"CloseFPAfterCall": ((523, LCID, 4, 0),()),
		"EditMode": ((558, LCID, 4, 0),()),
		"FPAllowRTPopup": ((508, LCID, 4, 0),()),
		"FPAutoCenter": ((511, LCID, 4, 0),()),
		"FPBehavior": ((601, LCID, 4, 0),()),
		"FPHiliteReturnButton": ((509, LCID, 4, 0),()),
		"FPKeepWinProps": ((575, LCID, 4, 0),()),
		"FPMinimizeable": ((583, LCID, 4, 0),()),
		"FPMonitor": ((629, LCID, 4, 0),()),
		"FPResizable": ((507, LCID, 4, 0),()),
		"FPResizeable": ((584, LCID, 4, 0),()),
		"FPRunTransparently": ((628, LCID, 4, 0),()),
		"FPShowMenuBar": ((513, LCID, 4, 0),()),
		"FPShowScrollBars": ((512, LCID, 4, 0),()),
		"FPSizeToScreen": ((510, LCID, 4, 0),()),
		"FPState": ((608, LCID, 4, 0),()),
		"FPTitleBarVisible": ((505, LCID, 4, 0),()),
		"FPTransparency": ((627, LCID, 4, 0),()),
		"FPWinBounds": ((536, LCID, 4, 0),()),
		"FPWinClosable": ((506, LCID, 4, 0),()),
		"FPWinCustomTitle": ((561, LCID, 4, 0),()),
		"FPWinIsFrontMost": ((535, LCID, 4, 0),()),
		"FPWinOpen": ((534, LCID, 4, 0),()),
		"FPWinOrigin": ((552, LCID, 4, 0),()),
		"FPWinPanelBounds": ((556, LCID, 4, 0),()),
		"FPWinTitle": ((553, LCID, 4, 0),()),
		"HelpDocumentPath": ((533, LCID, 4, 0),()),
		"HelpDocumentTag": ((532, LCID, 4, 0),()),
		"LogAtFinish": ((550, LCID, 4, 0),()),
		"LogFilePath": ((549, LCID, 4, 0),()),
		"PrintHeaderDatePrint": ((592, LCID, 4, 0),()),
		"PrintHeaderModifyDate": ((593, LCID, 4, 0),()),
		"PrintHeaderPageNumber": ((594, LCID, 4, 0),()),
		"PrintHeaderVIIcon": ((595, LCID, 4, 0),()),
		"PrintHeaderVIName": ((590, LCID, 4, 0),()),
		"PrintLogFileAtFinish": ((551, LCID, 4, 0),()),
		"PrintMargins": ((589, LCID, 4, 0),()),
		"PrintingBDScaling": ((610, LCID, 4, 0),()),
		"PrintingFPScaling": ((588, LCID, 4, 0),()),
		"PrintingHeaderVIPath": ((596, LCID, 4, 0),()),
		"PrintingHeaders": ((587, LCID, 4, 0),()),
		"PrintingOrientation": ((586, LCID, 4, 0),()),
		"RunTimeMenuPath": ((580, LCID, 4, 0),()),
		"ShowFPOnCall": ((522, LCID, 4, 0),()),
		"TBShowAbortButton": ((517, LCID, 4, 0),()),
		"TBShowFreeRunButton": ((516, LCID, 4, 0),()),
		"TBShowRunButton": ((515, LCID, 4, 0),()),
		"TBVisible": ((514, LCID, 4, 0),()),
	}

class _Application(DispatchBaseClass):
	"""Application DispInterface"""
	CLSID = IID('{F7E928FD-D76E-4B3D-B7B7-3E97A9609460}')
	coclass_clsid = IID('{0725EB75-1C58-45C3-86C4-57CBBAF64E35}')

	def BringToFront(self):
		"""On Windows and Mac OS, brings the application windows to the front."""
		return self._oleobj_.InvokeTypes(2014, LCID, 1, (24, 0), (),)

	def BrowseDataSocket(self, prompt=defaultNamedOptArg, selectedURL=pythoncom.Missing):
		"""Launches the <B>DataSocket Browser</B> dialog box to establish a connection to a DataSocket item."""
		return self._ApplyTypes_(2043, 1, (24, 0), ((12, 17), (16396, 18)), 'BrowseDataSocket', None,prompt
			, selectedURL)

	# Result is of type VirtualInstrument
	def GetVIReference(self, viPath=defaultNamedNotOptArg, password=defaultNamedOptArg, resvForCall=defaultNamedOptArg, options=defaultNamedOptArg):
		"""Get Reference to a VI specified by path."""
		ret = self._oleobj_.InvokeTypes(2004, LCID, 1, (9, 0), ((8, 1), (12, 17), (12, 17), (12, 17)),viPath
			, password, resvForCall, options)
		if ret is not None:
			ret = Dispatch(ret, 'GetVIReference', '{49859563-694E-4434-8E8F-1FA189F1337A}', UnicodeToString=0)
		return ret

	def GetVIVersion(self, viPath=defaultNamedNotOptArg, versNum=pythoncom.Missing):
		"""Returns the version of LabVIEW in which the VI was last saved. LabVIEW does not open the VI when retrieving the version information. If you specify a path to a file that is not a VI, LabVIEW returns error 6559."""
		return self._ApplyTypes_(2041, 1, (8, 0), ((8, 1), (16387, 2)), 'GetVIVersion', None,viPath
			, versNum)

	def LibraryGetFileLVVersion(self, libPath=defaultNamedNotOptArg, versNum=pythoncom.Missing):
		"""Returns the version of LabVIEW in which the library was created."""
		return self._ApplyTypes_(2158, 1, (8, 0), ((8, 1), (16396, 18)), 'LibraryGetFileLVVersion', None,libPath
			, versNum)

	def Quit(self):
		"""Quits the Application"""
		return self._oleobj_.InvokeTypes(2013, LCID, 1, (24, 0), (),)

	def ResolveSymbolicPath(self, symbolicPath=defaultNamedNotOptArg, actualPath=pythoncom.Missing):
		"""If the input path is a LabVIEW symbolic path, such as those that the Document Path property returns, this method converts it into an absolute path. For example, if you wire <helpdir>:glang.chm, this method returns C:Program FilesNational Instrumen"""
		return self._ApplyTypes_(2044, 1, (24, 0), ((8, 1), (16392, 2)), 'ResolveSymbolicPath', None,symbolicPath
			, actualPath)

	def _CompareTypes(self, typeDesc1=defaultNamedNotOptArg, typeDesc2=defaultNamedNotOptArg, options=defaultNamedOptArg):
		"""Compares 2 type descriptors. The return value is a bit mask. Look for 'sUnknown' in StateBits.h to figure out what the bits correspond to. Options is also a bit mask. Look for 'kAllNameChk' in datatype.cpp to specify the bits. This function is being """
		return self._oleobj_.InvokeTypes(2028, LCID, 1, (3, 0), ((12, 1), (12, 1), (12, 17)),typeDesc1
			, typeDesc2, options)

	def _CreateLVClsInst(self, classID=defaultNamedNotOptArg):
		"""Creates an instance of a LabVIEW class object, in particularly, an IDispatch* to an IAnalogWaveForm, IDigitalWaveForm, or IWaveForms object of one of the available waveform types"""
		return self._ApplyTypes_(2057, 1, (12, 0), ((3, 1),), '_CreateLVClsInst', None,classID
			)

	def _GetVICPTMCRC(self, viPath=defaultNamedNotOptArg, cptm_crc=pythoncom.Missing):
		"""Gets the CRC (checksum) for the connector pane type map (CPTM) of a VI without loading the VI. This will remove timestamps before it calculates the CRC so that controls that timestamps will not affect the CRC value. This property will return the old """
		return self._ApplyTypes_(2107, 1, (24, 0), ((8, 1), (16387, 2)), '_GetVICPTMCRC', None,viPath
			, cptm_crc)

	def _GetVICPTMCRCNew(self, viPath=defaultNamedNotOptArg, cptm_crc=pythoncom.Missing):
		"""Gets the CRC (checksum) for the connector pane type map (CPTM) of a VI without loading the VI. If you specify a path to a file that is not a VI, LabVIEW returns error 1059."""
		return self._ApplyTypes_(2143, 1, (24, 0), ((8, 1), (16387, 2)), '_GetVICPTMCRCNew', None,viPath
			, cptm_crc)

	_prop_map_get_ = {
		"AllProjects": (105, 2, (12, 0), (), "AllProjects", None),
		"AllVIsInMemory": (28, 2, (12, 0), (), "AllVIsInMemory", None),
		"AppKind": (3, 2, (3, 0), (), "AppKind", None),
		"AppName": (0, 2, (8, 0), (), "AppName", None),
		"AppTargetCPU": (5, 2, (3, 0), (), "AppTargetCPU", None),
		"AppTargetOS": (4, 2, (3, 0), (), "AppTargetOS", None),
		"ApplicationDirectory": (25, 2, (8, 0), (), "ApplicationDirectory", None),
		"AutomaticClose": (35, 2, (11, 0), (), "AutomaticClose", None),
		"CmdArgs": (79, 2, (12, 0), (), "CmdArgs", None),
		"DefaultDataLocation": (87, 2, (8, 0), (), "DefaultDataLocation", None),
		"ExportedVIs": (8, 2, (12, 0), (), "ExportedVIs", None),
		"Language": (99, 2, (8, 0), (), "Language", None),
		"OSName": (6, 2, (8, 0), (), "OSName", None),
		"OSVersion": (7, 2, (8, 0), (), "OSVersion", None),
		"PrintDefaultPrinter": (73, 2, (8, 0), (), "PrintDefaultPrinter", None),
		"PrintMethod": (74, 2, (3, 0), (), "PrintMethod", None),
		"PrintersAvailable": (75, 2, (12, 0), (), "PrintersAvailable", None),
		"PrintingColorDepth": (72, 2, (11, 0), (), "PrintingColorDepth", None),
		"RTHostConnected": (90, 2, (11, 0), (), "RTHostConnected", None),
		"ShowFPTipStrips": (63, 2, (11, 0), (), "ShowFPTipStrips", None),
		"UserName": (1, 2, (8, 0), (), "UserName", None),
		"VIServerPort": (93, 2, (3, 0), (), "VIServerPort", None),
		"Version": (2, 2, (8, 0), (), "Version", None),
		"_DisableGettingStartedWindow": (171, 2, (11, 0), (), "_DisableGettingStartedWindow", None),
		"_ModuleHandle": (101, 2, (3, 0), (), "_ModuleHandle", None),
		"_ParentWindowForDialogs": (54, 2, (3, 0), (), "_ParentWindowForDialogs", None),
		"_ProcessID": (80, 2, (3, 0), (), "_ProcessID", None),
		"_WindowForPanelOrigin": (100, 2, (3, 0), (), "_WindowForPanelOrigin", None),
	}
	_prop_map_put_ = {
		"AutomaticClose": ((35, LCID, 4, 0),()),
		"PrintDefaultPrinter": ((73, LCID, 4, 0),()),
		"PrintMethod": ((74, LCID, 4, 0),()),
		"PrintingColorDepth": ((72, LCID, 4, 0),()),
		"ShowFPTipStrips": ((63, LCID, 4, 0),()),
		"VIServerPort": ((93, LCID, 4, 0),()),
		"_DisableGettingStartedWindow": ((171, LCID, 4, 0),()),
		"_ParentWindowForDialogs": ((54, LCID, 4, 0),()),
		"_WindowForPanelOrigin": ((100, LCID, 4, 0),()),
	}
	# Default property for this class is 'AppName'
	def __call__(self):
		return self._ApplyTypes_(*(0, 2, (8, 0), (), "AppName", None))
	# str(ob) and int(ob) will use __call__
	def __unicode__(self, *args):
		try:
			return unicode(self.__call__(*args))
		except pythoncom.com_error:
			return repr(self)
	def __str__(self, *args):
		return str(self.__unicode__(*args))
	def __int__(self, *args):
		return int(self.__call__(*args))

class _IApplication(DispatchBaseClass):
	"""Application Interface"""
	CLSID = IID('{31127543-E731-4E08-9A71-1F11620B69A8}')
	coclass_clsid = IID('{0725EB75-1C58-45C3-86C4-57CBBAF64E35}')

	_prop_map_get_ = {
		"AllProjects": (105, 2, (12, 0), (), "AllProjects", None),
		"AllVIsInMemory": (28, 2, (12, 0), (), "AllVIsInMemory", None),
		"AppKind": (3, 2, (3, 0), (), "AppKind", None),
		"AppName": (0, 2, (8, 0), (), "AppName", None),
		"AppTargetCPU": (5, 2, (3, 0), (), "AppTargetCPU", None),
		"AppTargetOS": (4, 2, (3, 0), (), "AppTargetOS", None),
		"ApplicationDirectory": (25, 2, (8, 0), (), "ApplicationDirectory", None),
		"AutomaticClose": (35, 2, (11, 0), (), "AutomaticClose", None),
		"CmdArgs": (79, 2, (12, 0), (), "CmdArgs", None),
		"DefaultDataLocation": (87, 2, (8, 0), (), "DefaultDataLocation", None),
		"ExportedVIs": (8, 2, (12, 0), (), "ExportedVIs", None),
		"Language": (99, 2, (8, 0), (), "Language", None),
		"OSName": (6, 2, (8, 0), (), "OSName", None),
		"OSVersion": (7, 2, (8, 0), (), "OSVersion", None),
		"PrintDefaultPrinter": (73, 2, (8, 0), (), "PrintDefaultPrinter", None),
		"PrintMethod": (74, 2, (3, 0), (), "PrintMethod", None),
		"PrintersAvailable": (75, 2, (12, 0), (), "PrintersAvailable", None),
		"PrintingColorDepth": (72, 2, (11, 0), (), "PrintingColorDepth", None),
		"RTHostConnected": (90, 2, (11, 0), (), "RTHostConnected", None),
		"ShowFPTipStrips": (63, 2, (11, 0), (), "ShowFPTipStrips", None),
		"UserName": (1, 2, (8, 0), (), "UserName", None),
		"VIServerPort": (93, 2, (3, 0), (), "VIServerPort", None),
		"Version": (2, 2, (8, 0), (), "Version", None),
		"_DisableGettingStartedWindow": (171, 2, (11, 0), (), "_DisableGettingStartedWindow", None),
		"_ModuleHandle": (101, 2, (3, 0), (), "_ModuleHandle", None),
		"_ParentWindowForDialogs": (54, 2, (3, 0), (), "_ParentWindowForDialogs", None),
		"_ProcessID": (80, 2, (3, 0), (), "_ProcessID", None),
		"_WindowForPanelOrigin": (100, 2, (3, 0), (), "_WindowForPanelOrigin", None),
	}
	_prop_map_put_ = {
		"AutomaticClose": ((35, LCID, 4, 0),()),
		"PrintDefaultPrinter": ((73, LCID, 4, 0),()),
		"PrintMethod": ((74, LCID, 4, 0),()),
		"PrintingColorDepth": ((72, LCID, 4, 0),()),
		"ShowFPTipStrips": ((63, LCID, 4, 0),()),
		"VIServerPort": ((93, LCID, 4, 0),()),
		"_DisableGettingStartedWindow": ((171, LCID, 4, 0),()),
		"_ParentWindowForDialogs": ((54, LCID, 4, 0),()),
		"_WindowForPanelOrigin": ((100, LCID, 4, 0),()),
	}
	# Default property for this class is 'AppName'
	def __call__(self):
		return self._ApplyTypes_(*(0, 2, (8, 0), (), "AppName", None))
	# str(ob) and int(ob) will use __call__
	def __unicode__(self, *args):
		try:
			return unicode(self.__call__(*args))
		except pythoncom.com_error:
			return repr(self)
	def __str__(self, *args):
		return str(self.__unicode__(*args))
	def __int__(self, *args):
		return int(self.__call__(*args))

class _IVI(DispatchBaseClass):
	"""VI Interface"""
	CLSID = IID('{BAD4CD9F-6BDE-46EC-A871-E193FCBC2A41}')
	coclass_clsid = None

	_prop_map_get_ = {
		"AllowDebugging": (518, 2, (11, 0), (), "AllowDebugging", None),
		"BDSize": (543, 2, (3, 0), (), "BDSize", None),
		"Callees": (545, 2, (12, 0), (), "Callees", None),
		"Callers": (544, 2, (12, 0), (), "Callers", None),
		"CloneName": (645, 2, (8, 0), (), "CloneName", None),
		"CloseFPAfterCall": (523, 2, (11, 0), (), "CloseFPAfterCall", None),
		"CodeSize": (540, 2, (3, 0), (), "CodeSize", None),
		"DataSize": (541, 2, (3, 0), (), "DataSize", None),
		"Description": (502, 2, (8, 0), (), "Description", None),
		"EditMode": (558, 2, (11, 0), (), "EditMode", None),
		"ExecPriority": (526, 2, (3, 0), (), "ExecPriority", None),
		"ExecState": (557, 2, (3, 0), (), "ExecState", None),
		"FPAllowRTPopup": (508, 2, (11, 0), (), "FPAllowRTPopup", None),
		"FPAutoCenter": (511, 2, (11, 0), (), "FPAutoCenter", None),
		"FPBehavior": (601, 2, (3, 0), (), "FPBehavior", None),
		"FPHiliteReturnButton": (509, 2, (11, 0), (), "FPHiliteReturnButton", None),
		"FPKeepWinProps": (575, 2, (11, 0), (), "FPKeepWinProps", None),
		"FPMinimizeable": (583, 2, (11, 0), (), "FPMinimizeable", None),
		"FPModificationBitSet": (538, 2, (3, 0), (), "FPModificationBitSet", None),
		"FPMonitor": (629, 2, (2, 0), (), "FPMonitor", None),
		"FPResizable": (507, 2, (11, 0), (), "FPResizable", None),
		"FPResizeable": (584, 2, (11, 0), (), "FPResizeable", None),
		"FPRunTransparently": (628, 2, (11, 0), (), "FPRunTransparently", None),
		"FPShowMenuBar": (513, 2, (11, 0), (), "FPShowMenuBar", None),
		"FPShowScrollBars": (512, 2, (11, 0), (), "FPShowScrollBars", None),
		"FPSize": (542, 2, (3, 0), (), "FPSize", None),
		"FPSizeToScreen": (510, 2, (11, 0), (), "FPSizeToScreen", None),
		"FPState": (608, 2, (3, 0), (), "FPState", None),
		"FPTitleBarVisible": (505, 2, (11, 0), (), "FPTitleBarVisible", None),
		"FPTransparency": (627, 2, (16, 0), (), "FPTransparency", None),
		"FPWinBounds": (536, 2, (12, 0), (), "FPWinBounds", None),
		"FPWinClosable": (506, 2, (11, 0), (), "FPWinClosable", None),
		"FPWinCustomTitle": (561, 2, (11, 0), (), "FPWinCustomTitle", None),
		"FPWinIsFrontMost": (535, 2, (11, 0), (), "FPWinIsFrontMost", None),
		"FPWinOpen": (534, 2, (11, 0), (), "FPWinOpen", None),
		"FPWinOrigin": (552, 2, (12, 0), (), "FPWinOrigin", None),
		"FPWinPanelBounds": (556, 2, (12, 0), (), "FPWinPanelBounds", None),
		"FPWinTitle": (553, 2, (8, 0), (), "FPWinTitle", None),
		"HelpDocumentPath": (533, 2, (8, 0), (), "HelpDocumentPath", None),
		"HelpDocumentTag": (532, 2, (8, 0), (), "HelpDocumentTag", None),
		"IsCloneVI": (646, 2, (11, 0), (), "IsCloneVI", None),
		"IsReentrant": (525, 2, (11, 0), (), "IsReentrant", None),
		"LogAtFinish": (550, 2, (11, 0), (), "LogAtFinish", None),
		"LogFilePath": (549, 2, (8, 0), (), "LogFilePath", None),
		"Name": (500, 2, (8, 0), (), "Name", None),
		# Method 'OwningApp' returns object of type '_Application'
		"OwningApp": (623, 2, (9, 0), (), "OwningApp", '{F7E928FD-D76E-4B3D-B7B7-3E97A9609460}'),
		"Path": (501, 2, (8, 0), (), "Path", None),
		"PreferredExecSystem": (559, 2, (3, 0), (), "PreferredExecSystem", None),
		"PrintHeaderDatePrint": (592, 2, (11, 0), (), "PrintHeaderDatePrint", None),
		"PrintHeaderModifyDate": (593, 2, (11, 0), (), "PrintHeaderModifyDate", None),
		"PrintHeaderPageNumber": (594, 2, (11, 0), (), "PrintHeaderPageNumber", None),
		"PrintHeaderVIIcon": (595, 2, (11, 0), (), "PrintHeaderVIIcon", None),
		"PrintHeaderVIName": (590, 2, (11, 0), (), "PrintHeaderVIName", None),
		"PrintLogFileAtFinish": (551, 2, (11, 0), (), "PrintLogFileAtFinish", None),
		"PrintMargins": (589, 2, (12, 0), (), "PrintMargins", None),
		"PrintingBDScaling": (610, 2, (11, 0), (), "PrintingBDScaling", None),
		"PrintingFPScaling": (588, 2, (11, 0), (), "PrintingFPScaling", None),
		"PrintingHeaderVIPath": (596, 2, (11, 0), (), "PrintingHeaderVIPath", None),
		"PrintingHeaders": (587, 2, (11, 0), (), "PrintingHeaders", None),
		"PrintingOrientation": (586, 2, (3, 0), (), "PrintingOrientation", None),
		"ReentrancyType": (648, 2, (12, 0), (), "ReentrancyType", None),
		"RunOnOpen": (524, 2, (11, 0), (), "RunOnOpen", None),
		"RunTimeMenuPath": (580, 2, (8, 0), (), "RunTimeMenuPath", None),
		"ShowFPOnCall": (522, 2, (11, 0), (), "ShowFPOnCall", None),
		"ShowFPOnLoad": (521, 2, (11, 0), (), "ShowFPOnLoad", None),
		"SuspendOnCall": (555, 2, (11, 0), (), "SuspendOnCall", None),
		"TBShowAbortButton": (517, 2, (11, 0), (), "TBShowAbortButton", None),
		"TBShowFreeRunButton": (516, 2, (11, 0), (), "TBShowFreeRunButton", None),
		"TBShowRunButton": (515, 2, (11, 0), (), "TBShowRunButton", None),
		"TBVisible": (514, 2, (11, 0), (), "TBVisible", None),
		"VIModificationBitSet": (537, 2, (3, 0), (), "VIModificationBitSet", None),
		"VIType": (562, 2, (3, 0), (), "VIType", None),
		"_CPTM_CRC": (614, 2, (3, 0), (), "_CPTM_CRC", None),
		"_CPTM_CRC_New": (639, 2, (3, 0), (), "_CPTM_CRC_New", None),
		"_CalleesPaths": (640, 2, (12, 0), (), "_CalleesPaths", None),
		"_CallersPaths": (641, 2, (12, 0), (), "_CallersPaths", None),
		"_FPWinOSWindow": (615, 2, (3, 0), (), "_FPWinOSWindow", None),
	}
	_prop_map_put_ = {
		"CloseFPAfterCall": ((523, LCID, 4, 0),()),
		"EditMode": ((558, LCID, 4, 0),()),
		"FPAllowRTPopup": ((508, LCID, 4, 0),()),
		"FPAutoCenter": ((511, LCID, 4, 0),()),
		"FPBehavior": ((601, LCID, 4, 0),()),
		"FPHiliteReturnButton": ((509, LCID, 4, 0),()),
		"FPKeepWinProps": ((575, LCID, 4, 0),()),
		"FPMinimizeable": ((583, LCID, 4, 0),()),
		"FPMonitor": ((629, LCID, 4, 0),()),
		"FPResizable": ((507, LCID, 4, 0),()),
		"FPResizeable": ((584, LCID, 4, 0),()),
		"FPRunTransparently": ((628, LCID, 4, 0),()),
		"FPShowMenuBar": ((513, LCID, 4, 0),()),
		"FPShowScrollBars": ((512, LCID, 4, 0),()),
		"FPSizeToScreen": ((510, LCID, 4, 0),()),
		"FPState": ((608, LCID, 4, 0),()),
		"FPTitleBarVisible": ((505, LCID, 4, 0),()),
		"FPTransparency": ((627, LCID, 4, 0),()),
		"FPWinBounds": ((536, LCID, 4, 0),()),
		"FPWinClosable": ((506, LCID, 4, 0),()),
		"FPWinCustomTitle": ((561, LCID, 4, 0),()),
		"FPWinIsFrontMost": ((535, LCID, 4, 0),()),
		"FPWinOpen": ((534, LCID, 4, 0),()),
		"FPWinOrigin": ((552, LCID, 4, 0),()),
		"FPWinPanelBounds": ((556, LCID, 4, 0),()),
		"FPWinTitle": ((553, LCID, 4, 0),()),
		"HelpDocumentPath": ((533, LCID, 4, 0),()),
		"HelpDocumentTag": ((532, LCID, 4, 0),()),
		"LogAtFinish": ((550, LCID, 4, 0),()),
		"LogFilePath": ((549, LCID, 4, 0),()),
		"PrintHeaderDatePrint": ((592, LCID, 4, 0),()),
		"PrintHeaderModifyDate": ((593, LCID, 4, 0),()),
		"PrintHeaderPageNumber": ((594, LCID, 4, 0),()),
		"PrintHeaderVIIcon": ((595, LCID, 4, 0),()),
		"PrintHeaderVIName": ((590, LCID, 4, 0),()),
		"PrintLogFileAtFinish": ((551, LCID, 4, 0),()),
		"PrintMargins": ((589, LCID, 4, 0),()),
		"PrintingBDScaling": ((610, LCID, 4, 0),()),
		"PrintingFPScaling": ((588, LCID, 4, 0),()),
		"PrintingHeaderVIPath": ((596, LCID, 4, 0),()),
		"PrintingHeaders": ((587, LCID, 4, 0),()),
		"PrintingOrientation": ((586, LCID, 4, 0),()),
		"RunTimeMenuPath": ((580, LCID, 4, 0),()),
		"ShowFPOnCall": ((522, LCID, 4, 0),()),
		"TBShowAbortButton": ((517, LCID, 4, 0),()),
		"TBShowFreeRunButton": ((516, LCID, 4, 0),()),
		"TBShowRunButton": ((515, LCID, 4, 0),()),
		"TBVisible": ((514, LCID, 4, 0),()),
	}

from win32com.client import CoClassBaseClass
# This CoClass is known by the name 'Software\Classes\Spice.Application.8'
class Application(CoClassBaseClass): # A CoClass
	# Application CoClass
	CLSID = IID('{0725EB75-1C58-45C3-86C4-57CBBAF64E35}')
	coclass_sources = [
	]
	coclass_interfaces = [
		_IApplication,
		_Application,
	]
	default_interface = _Application

RecordMap = {
}

CLSIDToClassMap = {
	'{31127543-E731-4E08-9A71-1F11620B69A8}' : _IApplication,
	'{BAD4CD9F-6BDE-46EC-A871-E193FCBC2A41}' : _IVI,
	'{F7E928FD-D76E-4B3D-B7B7-3E97A9609460}' : _Application,
	'{49859563-694E-4434-8E8F-1FA189F1337A}' : VirtualInstrument,
	'{0725EB75-1C58-45C3-86C4-57CBBAF64E35}' : Application,
}
CLSIDToPackageMap = {}
win32com.client.CLSIDToClass.RegisterCLSIDsFromDict( CLSIDToClassMap )
VTablesToPackageMap = {}
VTablesToClassMap = {
}


NamesToIIDMap = {
	'VirtualInstrument' : '{49859563-694E-4434-8E8F-1FA189F1337A}',
	'_IApplication' : '{31127543-E731-4E08-9A71-1F11620B69A8}',
	'_Application' : '{F7E928FD-D76E-4B3D-B7B7-3E97A9609460}',
	'_IVI' : '{BAD4CD9F-6BDE-46EC-A871-E193FCBC2A41}',
}

win32com.client.constants.__dicts__.append(constants.__dict__)

